#!/bin/sh

# iSub.sh

APDIR=~/Desktop

##### Preparation #####

echo Changing directory...
cd $APDIR

##### Backing up current kext #####

echo Making Folder to insert old extension in...
mkdir OldExtensions

echo Copying current extension to OldExtension folder...
cp -r /System/Library/Extensions/AppleUSBAudio.kext ~/Desktop/OldExtensions
cp -r /System/Library/Extensions/IOAudioFamily.kext ~/Desktop/OldExtensions

##### Installing files ######

echo Copying new extensions to /System/Library/Extensions...
echo If asked, please enter your password...
sudo cp -r AppleUSBAudio.kext /System/Library/Extensions
sudo cp -r IOAudioFamily.kext /System/Library/Extensions

echo Changing extension permissions...
sudo chmod -R 755 /System/Library/Extensions/AppleUSBAudio.kext
sudo chmod -R 755 /System/Library/Extensions/IOAudioFamily.kext

echo Changing extension owner...
sudo chown -R root:wheel /System/Library/Extensions/AppleUSBAudio.kext
sudo chown -R root:wheel /System/Library/Extensions/IOAudioFamily.kext

##### Deleteing extensions cache #####

echo Deleteing extensions cache...
sudo rm /System/Library/Extensions.mkext
sudo rm /System/Library/Extensions.kextcache

##### End of installation, asking user to restart ######

echo
echo
echo Installation complete, please restart.